#include "ConstantBuffers.hlsli"

float4 main( PS_INPUT input) : SV_TARGET
{
 
    float ang = SequenceRatio * 3.1415;
    float cosAng = cos(ang);
    float sinAng = sin(ang);
    float2 coords = float2( cosAng * input.Tex.x + sinAng * input.Tex.y,
                            -sinAng * input.Tex.x + cosAng * input.Tex.y ) * abs(sinAng) * 5;
        
    float4 colorTex = txDiffuse.Sample( samLinear, coords );
    float4 colorFlash = float4(1,1,1,1);
    float factor = (2.0 * (SequenceRatio - 0.5)) * (2.0 * (SequenceRatio - 0.5)) * (2.0 * (SequenceRatio - 0.5)) * (2.0 * (SequenceRatio - 0.5));
    return colorTex * (1.0 - factor) +  colorFlash * factor;
}